% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_fit.R
\name{RprobitB_fit}
\alias{RprobitB_fit}
\alias{print.RprobitB_fit}
\alias{summary.RprobitB_fit}
\alias{print.summary.RprobitB_fit}
\title{Create object of class \code{RprobitB_fit}}
\usage{
RprobitB_fit(
  data,
  scale,
  level,
  normalization,
  R,
  B,
  Q,
  latent_classes,
  prior,
  gibbs_samples,
  class_sequence,
  comp_time
)

\method{print}{RprobitB_fit}(x, ...)

\method{summary}{RprobitB_fit}(object, FUN = c(mean = mean, sd = stats::sd, `R^` = R_hat), ...)

\method{print}{summary.RprobitB_fit}(x, digits = 2, ...)
}
\arguments{
\item{data}{An object of class \code{RprobitB_data}.}

\item{scale}{[\code{character(1)}]\cr
A character which determines the utility scale. It is of the form
\verb{<parameter> := <value>}, where \verb{<parameter>} is either the name of a fixed
effect or \verb{Sigma_<j>,<j>} for the \verb{<j>}th diagonal element of \code{Sigma}, and
\verb{<value>} is the value of the fixed parameter.}

\item{normalization}{An object of class \code{RprobitB_normalization}.}

\item{R}{[\code{integer(1)}]\cr
The number of iterations of the Gibbs sampler.}

\item{B}{[\code{integer(1)}]\cr
The length of the burn-in period.}

\item{Q}{[\code{integer(1)}]\cr
The thinning factor for the Gibbs samples.}

\item{latent_classes}{[\code{list()} | \code{NULL}]\cr
Optionally parameters specifying the number of latent classes and their
updating scheme. The values in brackets are the default.
\itemize{
\item \code{C} (\code{1}): The fixed number (greater or equal 1) of (initial) classes.
\item \code{wb_update} (\code{FALSE}): Set to \code{TRUE} for weight-based class updates.
\item \code{dp_update} (\code{FALSE}): Set to \code{TRUE} for Dirichlet process class updates.
\item \code{Cmax} (\code{10}): The maximum number of latent classes.
}

The following specifications are used for the weight-based updating scheme:
\itemize{
\item \code{buffer} (\code{50}): The number of iterations to wait before the next update.
\item \code{epsmin} (\code{0.01}): The threshold weight for removing a latent class.
\item \code{epsmax} (\code{0.7}): The threshold weight for splitting a latent class.
\item \code{deltamin} (\code{0.1}): The minimum mean distance before merging two classes.
\item \code{deltashift} (\code{0.5}): The scale for shifting the class means after a split.
}}

\item{prior}{[\code{list}]\cr
A named list of parameters for the prior distributions. See the documentation
of \code{\link{check_prior}} for details about which parameters can be
specified.}

\item{gibbs_samples}{An object of class \code{RprobitB_gibbs_samples}.}

\item{class_sequence}{The sequence of class numbers during Gibbs sampling of length \code{R}.}

\item{comp_time}{The time spent for Gibbs sampling.}
}
\value{
An object of class \code{RprobitB_fit}.
}
\description{
This function creates an object of class \code{RprobitB_fit}.
}
\keyword{internal}
