\name{HiJACK}
\alias{HiJACK}
\title{Jackknife a list of events
}
\description{Jackknife a list of events
}
\usage{
HiJACK(lps, sta, vel)
}
\arguments{
  \item{lps}{list of earthquake event pickfiles, each element is an
    individual pickfile list, with STAS: relative timing of phase arrivals
    
}
  \item{sta}{staiton list
}
 \item{vel}{velocity list
}


}
\details{Driver for BLACKJACK
}
\value{jackknife pseudovalues for each event
}
\references{
  Iversen, E. S., and J. M. Lees (1996), A statistical technique for
  validating velocity models,
  Bull. Seismol. Soc. Am. 86(6), 1853-1862.
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{BLACKJACK
}
\examples{

#####  uses external files, runs Vlocate on each one
#### lps = list of file names to be read

data(cosopix)
data(wu_coso.vel)
data(coso_sta_LLZ)

COSOjack = HiJACK(cosopix, coso_sta_LLZ, wu_coso.vel)

proj = GEOmap::setPROJ(2, mean(coso_sta_LLZ$lat),
mean(coso_sta_LLZ$lon))


####  show stats
plotJACKLLZ(COSOjack, coso_sta_LLZ, proj, PLOT=1 )


####  show maps
plotJACKLLZ(COSOjack, coso_sta_LLZ, proj, PLOT=2 )



}
\keyword{misc}
