\name{PCsaveWPX}
\alias{PCsaveWPX}
\alias{SaveCSV}
\title{Save WPX list 
}
\description{
Save a WPX list to a file on the local file system.
}
\usage{
PCsaveWPX(twpx, destdir = NULL)
}
\arguments{
  \item{twpx}{WPX list
}
  \item{destdir}{character, destination directory, default=NULL
}
}
\details{
Creates a file with the list as in native
binary format.  This file can
be loaded with the standard load function in R.
The name of the file is 
created by using the minimum time extracted from the WPX list.
The suffix on the file name is RDATA.
When reading in, the object created is named "twpx"
for further processing.

destdir must be set, otherwise the destination directory will be
temporary.  Typically this is set to a local directory where the user
has write access.


}
\value{Side effects on file system.  The name of the output file is returned.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{User must have write access to the destination directory.

}


\seealso{
RSEIS::addWPX,	RSEIS::catWPX,	RSEIS::checkWPX,	RSEIS::cleanWPX,	RSEIS::clusterWPX,	RSEIS::repairWPX,	RSEIS::setWPX
}
\examples{

#####  save files as RDS to users disk

s1 = RSEIS::setWPX(name="HI", yr=2011, jd=231, hr=4, mi=3, sec = runif(5))

hh = PCsaveWPX(s1, destdir= tempdir() )

###   read in the data
twpx = readRDS(hh)

data.frame(twpx)

}
\keyword{misc}
