\name{cosopix}
\alias{cosopix}
\docType{data}
\title{Selection of pickfiles from Coso Geothermal Field
}
\description{
  Set of selected seismic arrival files with hypocenter locations.
}
\usage{data("cosopix")}
\format{
  List consisting of:
  \itemize{
\item PF: original text version of file, as read from disk
\item AC: Acard: hypocenter information
\item LOC: location
\item MC: Fault Mechanizm card
\item STAS: Station information
\item LIP: Error Ellipse
\item E: E-card
\item F: F-card
\item filename: original file location
\item UWFILEID: UW file identification
\item comments: Comments on event location
\item OSTAS: Station names
\item H: High resolution location numbers
\item N: Stations Not used in location
}
}
\details{
  Each element of this list is an individual earthquake record.
}

\examples{

data(cosopix)
A = sapply(cosopix, '[[', 'LOC')
###  gather stations

ST.name = vector(mode='character')
ST.lat = vector(mode='numeric')
ST.lon = vector(mode='numeric')
ST.z = vector(mode='numeric')

for(i in 1:length(cosopix))
{
g = cosopix[[i]]
g = data.frame(g$STAS )
w = which(!is.na(g$lat) )
ST.name = c(ST.name, g$name[w])
ST.lat = c(ST.lat, g$lat[w])
ST.lon = c(ST.lon, g$lon[w])
ST.z = c(ST.z, g$z[w])
}

notdup = !duplicated(ST.name)

name = ST.name[notdup ]
lat = ST.lat[notdup ]
lon =ST.lon[notdup ]
z = ST.z[notdup ]

plot(range(c(A[9, ], lon)) , range(c(A[8, ], lat)) , type='n',
xlab='Lon', ylab='Lat')
points(lon, lat, pch=6)

text(lon, lat, labels=name, pos=3)

points(A[9, ], A[8, ])



}
\keyword{misc}
