% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{Rule5}
\alias{Rule5}
\title{Rule 5}
\usage{
Rule5(x, zoneB, minNPoints = 2, nPoints = 3, ...)
}
\arguments{
\item{x}{Numerical vector}

\item{zoneB}{Vector of zone borders}

\item{minNPoints}{Minimal number of points in a sequence violating a rule}

\item{nPoints}{Sequence of consequtive points to be evaluated}

\item{...}{unspecified arguments of a function}
}
\value{
Vector of the same length as x
}
\description{
Two out of three consecutive points beyond the 2*sigma limits on same side of center line.
}
\details{
0 means: ok \cr
1 means: violation \cr

inequality used during evaluation \cr
Rule is violated also if the first two points are beyond the 2*sigma limits
During calculation of EvaluateRules function wiht controlLimitDistance <= 2, the evaluation of this rule is suppressed
}
\examples{
limits = CalculateLimits(x = rnorm(10), lcl = NA, cl = 100, ucl = NA, type = 'i')
zones = CalculateZoneBorders(limits)
Rule5(x = rnorm(20), zoneB = zones, minNPoints = 2, nPoints = 3)
#zones is object created by function CalculateZoneBorders()
}
