% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossFittedR2.R
\name{CF_Rsq.measure}
\alias{CF_Rsq.measure}
\title{Function to calculate the Rsq function as a total effect size measure for mediation effect using cross-fitted estimation}
\usage{
CF_Rsq.measure(
  Y,
  M,
  Covar = NULL,
  X,
  iter.max = 3,
  nsis = NULL,
  first.half = TRUE,
  seed = 2022,
  tune = c("aic", "bic"),
  penalty = c("MCP", "lasso")
)
}
\arguments{
\item{Y}{vector of the outcome of interest; outcome has to follow a Gaussian distribution.}

\item{M}{matrix of putative mediators}

\item{Covar}{covariates matrix}

\item{X}{vector of the independent variable of interest, e.g. environmental variable}

\item{iter.max}{Maximum number of iterations used in iSIS, default = 3 (details see the SIS package).}

\item{nsis}{Number of predictors recruited by iSIS, default = NULL}

\item{first.half}{TRUE: split sample into two halves by the order in the dataset. FALSE: randomly split samples into halves, default = TRUE.}

\item{seed}{Random seed used for sample splitting, default = 2022.}

\item{tune}{Method for tuning the regularization parameter of the penalized likelihood subproblems and of the final model selected by (i)SIS. Options include tune = 'bic' and tune = 'aic'.}

\item{penalty}{The penalty to be applied in the regularized likelihood subproblems. 'MCP', and 'lasso' are provided. 'MCP' is recommended.}
}
\value{
Output Vector consisting of Rsq mediated(Rsq.mediated), Lower confidence bound constructed by the asymptotic variance (CI_asym_low), Upper confidence bound constructed by the asymptotic variance (CI_asym_up), Lower confidence bound constructed by the conservative variance (CI_cons_low), Upper confidence bound constructed by the conservative variance (CI_cons_up), number of selected mediators in subsample 1 (pab1), number of selected mediators in subsample 2 (pab2), and the Rsq that used to calculate the Rsq measure: variance of outcome explained by mediator (Rsq.YM), variance of outcome explained by the independent variable (Rsq.YX), and variance of outcome explained by mediator and independent variable (Rsq.YMX); Sample Size in analysis (Sample Size)

Name of selected mediators in subsample 1 (select1)

Name of selected mediators in subsample 2 (select2)
}
\description{
Function to calculate the Rsq function as a total effect size measure for mediation effect using cross-fitted estimation
}
\examples{
{
\donttest{
data(example)
attach(example)
CF_Rsq.measure(Y=Y, M=M, X=X, tune = "bic", penalty = "MCP")
}
}
}
