% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtize_col.R
\name{dtize_col}
\alias{dtize_col}
\title{Discretize a Numeric Column}
\usage{
dtize_col(
  column,
  cutoff = "median",
  labels = c("low", "high"),
  include_right = TRUE,
  infinity = TRUE,
  include_lowest = TRUE,
  na_fill = "none"
)
}
\arguments{
\item{column}{A numeric vector to discretize.}

\item{cutoff}{A numeric vector specifying cutoff points, or a string ("mean" or "median").}

\item{labels}{A character vector specifying labels for the resulting categories.}

\item{include_right}{Logical. If \code{TRUE}, intervals are closed on the right (default \code{TRUE}).}

\item{infinity}{Logical. If \code{TRUE}, extends cutoffs to \code{-Inf} and \code{Inf} (default \code{TRUE}).}

\item{include_lowest}{Logical. If \code{TRUE}, the lowest interval is closed on the left (default \code{TRUE}).}

\item{na_fill}{A string specifying the method to impute missing values: "none", "mean", or "median" (default "none").}
}
\value{
A factor with the same length as \code{column}, where each value is categorized based on the cutoffs.
}
\description{
Discretizes a numeric vector into categories based on specified cutoff points.
The function handles missing values, allows for infinite bounds, and supports
predefined cutoffs such as the mean or median.
}
\examples{
data(BrookTrout)

# Example with predefined cutoffs
discrete_water_temp <- dtize_col(
  BrookTrout$eDNAConc, cutoff=13.3,
  labels=c("low", "high"),
  infinity=TRUE
)

# Example with median as cutoff
discrete_pH <- dtize_col(BrookTrout$pH, cutoff="median")

# Example with missing value imputation
filled_col <- dtize_col(
  c(1, 2, NA, 4, 5),
  cutoff = "mean",
  include_right=FALSE,
  na_fill = "mean"
)

}
