% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgRaySearch.r
\name{raysearchMulti}
\alias{raysearchMulti}
\title{Find all intersections of rays and a mesh}
\usage{
raysearchMulti(x, mesh, maxtol = 1e+15, threads = 1, offset = 0.001)
}
\arguments{
\item{x}{a triangular mesh of class 'mesh3d' or a list containing vertices and vertex normals (fitting the naming conventions of 'mesh3d'). In the second case x must contain x$vb = 3 x n matrix containing 3D-coordinates and x$normals = 3 x n matrix containing normals associated with x$vb.}

\item{mesh}{triangular mesh to be intersected.}

\item{maxtol}{maximum distance to search along ray}

\item{threads}{number of threads used during search.}

\item{offset}{amount to offset the hit points along the ray to find the next intersection. This is needed to avoid finding the same intersection over and over again.}
}
\value{
list with following items:
\item{intersects }{a list containing the result of \code{\link{vcgRaySearch}} at each step of the intersection search}
\item{hits }{Vector containging number of intersections for each ray}
}
\description{
Find all intersections by tracing rays through mesh                                       #
}
\details{
This function iteratively uses \code{\link{vcgRaySearch}} to find all intersections of rays and a given surface mesh.
}
\examples{
\dontrun{
require(Morpho); require(rgl)
data(humface)
humface1 <- scalemesh(humface,size=1.1)
mesh <- mergeMeshes(humface,humface1)     #get normals of landmarks
x <- vcgClost(humface.lm, humface)
# offset landmarks along their normals for a negative amount of -5mm
x$vb[1:3,] <- x$vb[1:3,]+x$normals[1:3,]*-5

myint <- raysearchMulti(x,mesh)
wire3d(mesh,col="white")
spheres3d(vert2points(x),radius=0.5,col=3)
plotNormals(x,length=55,lwd=2)
for (i in 1:length(myint$intersects)) {
 spheres3d(vert2points(myint$intersects[[i]])[which(as.logical(myint$intersects[[i]]$quality)),]
                       ,col=i)
}
}
}
\seealso{
\code{\link{vcgRaySearch}}
}
