% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAMGEP.R
\name{samgep}
\alias{samgep}
\title{Semi-supervised Adaptive Markov Gaussian Process (SAMGEP)}
\usage{
samgep(
  dat_train = NULL,
  dat_test = NULL,
  Cindices = NULL,
  w = NULL,
  w0 = NULL,
  V = NULL,
  observed = NULL,
  nX = 10,
  covs = NULL,
  survival = FALSE,
  Estep = Estep_partial,
  Xtrain = NULL,
  Xtest = NULL,
  alpha = NULL,
  r = NULL,
  lambda = NULL,
  surrIndex = NULL,
  nCores = 1
)
}
\arguments{
\item{dat_train}{(optional if Xtrain is supplied) Raw training data set, including patient IDs (ID), healthcare utilization feature (H) and censoring time (C)}

\item{dat_test}{(optional) Raw testing data set, including patient IDs (ID), a healthcare utilization feature (H) and censoring time (C)}

\item{Cindices}{(optional if Xtrain is supplied) Column indices of EHR feature counts in dat_train/dat_test}

\item{w}{(optional if Xtrain is supplied) Pre-optimized EHR feature weights}

\item{w0}{(optional if Xtrain is supplied) Initial (i.e. partially optimized) EHR feature weights}

\item{V}{(optional if Xtrain is supplied) nFeatures x nEmbeddings embeddings matrix}

\item{observed}{(optional if Xtrain is supplied) IDs of patients with observed outcome labels}

\item{nX}{Number of embedding features (defaults to 10)}

\item{covs}{(optional) Baseline covariates to include in model; not yet operational}

\item{survival}{Binary indicator of whether target phenotype is of type survival (i.e. stays positive after incident event) or relapsing-remitting (defaults to FALSE)}

\item{Estep}{E-step function to use (Estep_partial or Estep_full; defaults to Estep_partial)}

\item{Xtrain}{(optional) Embedded training data set, including patient IDs (ID), healthcare utilization feature (H) and censoring time (C)}

\item{Xtest}{(optional) Embedded testing data set, including patient IDs (ID), healthcare utilization feature (H) and censoring time (C)}

\item{alpha}{(optional) Relative weight of semi-supervised to supervised MGP predictors in SAMGEP ensemble}

\item{r}{(optional) Scaling factor of inter-temporal correlation}

\item{lambda}{(optional) L1 regularization hyperparameter for feature weight (w) optimization}

\item{surrIndex}{(optional) Index (within Cindices) of primary surrogate index for outcome event}

\item{nCores}{Number of cores to use for parallelization (defaults to 1)}
}
\value{
w_opt Optimized feature weights (w)

r_opt Optimized inter-temporal correlation scaling factor (r)

alpha_opt Optimized semi-supservised:supervised relative weight (alpha)

lambda_opt Optiized L1 regularization hyperparameter (lambda)

margSup Posterior probability predictions of supervised model (MGP Supervised)

margSemisup Posterior probability predictions of semi-supervised model (MGP Semi-supervised)

margMix Posterior probability predictions of SAMGEP

cumSup Cumulative probability predictions of supervised model (MGP Supervised)

cumSemisup Cumulative probability predictions of semi-supervised model (MGP Semi-supervised)

cumMix Cumulative probability predictions of SAMGEP
}
\description{
Semi-supervised Adaptive Markov Gaussian Process (SAMGEP)
}
