% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.R
\name{sampler.dp}
\alias{sampler.dp}
\title{Dirichlet process sampler}
\usage{
sampler.dp(currsbm, edges, sbmmod, sigma)
}
\arguments{
\item{currsbm}{the current state of the sampler}

\item{edges}{an \code{\link{edges}} object}

\item{sbmmod}{an \code{\link{sbmmod}} model}

\item{sigma}{random walk parameter for theta}
}
\value{
next state of \code{currsbm} object
}
\description{
Dirichlet process sampler
}
\examples{
model <- sbmmod(crp(4), param_norm(0,0,1,1,3,3,1,1), edges_norm())
trueSBM <- model$r(100)
Edges <- redges(trueSBM, model$edge)
dp_out <- sampler(Edges, model, 25, "dp", sigma=0.1)
}
\seealso{
For full algorithm details see \url{http://doi.org/10.17635/lancaster/thesis/296}
}
