% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authorization.R
\name{authorization}
\alias{authorization}
\alias{set_token}
\alias{validate_token}
\alias{unset_token}
\title{Authorization}
\usage{
set_token(client_id, client_secret, access_token, verbose = FALSE)

validate_token(access_token)

unset_token()
}
\arguments{
\item{client_id, client_secret}{A client ID and client secret can be obtained from the
\href{https://develop.battle.net/}{Blizzard Developer Portal}. For more information on
creating a client, visit
\href{https://develop.battle.net/documentation/guides/getting-started}{Getting Started}.}

\item{access_token}{An OAuth 2.0 access token required to use the Blizzard API. Access tokens can be
obtained by using \code{set_token} with a valid client ID and client secret.}

\item{verbose}{If verbose is set to TRUE, your access token will be printed on screen.}
}
\description{
The Blizzard API uses OAuth 2.0 for authorization. For more information on how Blizzard
   uses OAuth in their API, visit \url{https://develop.battle.net/documentation/guides/using-oauth}.

   Before using the Blizzard API, one must first create a client in the
   \href{https://develop.battle.net/}{Blizzard Developer Portal} and obtain a valid client ID and
   client secret. For more information on getting started, see:
   \href{https://develop.battle.net/documentation/guides/getting-started}{Getting Started}.

   Once a client has been created, use \code{\link{set_token}} and supply the client id and client
   secret as arguments to set an environment variable for all future API calls.

   Once \code{set_token()} has been used, an access token can be removed from the environment
   using \code{remove_token()}

   Note that access tokens are set to expire in 24 hours and, subsequently,
   a new token must be used for any future API calls.
}
\note{
Access tokens expire after 24 hours.
}
\examples{
\dontrun{
#Get and set a token as an environment variable
set_token(client_id = "YOUR CLIENT ID", client_secret = "YOUR CLIENT SECRET")

#Set an access token that you have already retrieved as an environment variable
set_token(access_token = "YOUR TOKEN")
}
\donttest{
# Ensure that a valid token is currently set as an environment variable
validate_token()
# Check if a token is valid
validate_token("TEST TOKEN")
}
# Remove token from environment variable
unset_token()
}
\references{
\itemize{
   \item \href{https://develop.battle.net/}{Blizzard Developer Portal}
   \item \href{https://develop.battle.net/documentation/guides/using-oauth}{Using OAuth}
   \item \href{https://develop.battle.net/documentation/guides/getting-started}{Getting Started}
   }
}
