% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{get_ladder}
\alias{get_ladder}
\title{Ladder Details and Profile Rank}
\usage{
get_ladder(region_id, realm_id, profile_id, ladder_id, host_region = "us")
}
\arguments{
\item{region_id}{A numeric argument indicating the region of the profile.
    \itemize{
        \item 1 = US Region
        \item 2 = EU Region
        \item 3 = KR/TW Region
        \item 5 = CN Region
}}

\item{realm_id}{A numeric argument indicating the realm of the profile. A realm is a subset
of the region.
 \itemize{
     \item{US Region}
         \itemize{
             \item{1 = US}
             \item{2 = LatAm}
         }
     \item{EU Region}
         \itemize{
             \item{1 = Europe}
             \item{2 = Russia}
     }
     \item{KR/TW Region}
         \itemize{
             \item{1 = Korea}
             \item{2 = Taiwan}
     }
 }}

\item{profile_id}{A unique, numeric identifier for an individual's profile.}

\item{ladder_id}{A unique identifier for a particular ladder. With the exception of Grandmaster, leagues
(bronze, silver, etc.), are separated into tiers (1,2,3) which are further separated into divisions.
These divisions, or ladders, each have a unique identifier.}

\item{host_region}{The host region that the API call will be sent to. For most API calls, the same data will be
returned regardless of which region the request is sent to. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides information about a particular ladder and the individual's rank and status within that
ladder (i.e. rank, MMR, etc.).
}
\examples{
\donttest{
# Obtaining the overall ladder performance of a profile.
try({
    ladderData <- get_ladder_summary(region_id = 1, realm_id = 1, profile_id = 4716773)

    # Choose a single ladder ID
    ladderID <- ladderData$allLadderMemberships$ladderId[1]

    # Get full ladder information and the profile's performance in this ladder
    get_ladder(region_id = 1, realm_id = 1, profile_id = 4716773, ladder_id = ladderID)
})
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
Other profile API calls: 
\code{\link{get_ladder_summary}()},
\code{\link{get_metadata}()},
\code{\link{get_profile}()},
\code{\link{get_static}()}
}
\concept{profile API calls}
