% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladder.R
\name{get_season}
\alias{get_season}
\title{Current Season Information}
\usage{
get_season(region_id, host_region = "us")
}
\arguments{
\item{region_id}{A numeric argument indicating the region of the profile.
    \itemize{
        \item 1 = US Region
        \item 2 = EU Region
        \item 3 = KR/TW Region
        \item 5 = CN Region
}}

\item{host_region}{The host region that the API call will be sent to. For most API calls, the same data will be
returned regardless of which region the request is sent to. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides the current season ID, starting date, and ending date.
}
\examples{
\donttest{
# Obtain current season information for the European region
try(get_season(region_id = 2))
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
Other ladder data API calls: 
\code{\link{get_gm_leaderboard}()}
}
\concept{ladder data API calls}
