% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/game_data.R
\name{get_season_data}
\alias{get_season_data}
\title{Season Data}
\usage{
get_season_data(season_id, host_region = "us")
}
\arguments{
\item{season_id}{A numeric argument indicating a particular ladder season. Currently, league data
is only available for season 28 and higher (i.e. data prior to this season is inaccessible).}

\item{host_region}{The host region that the API call will be sent to. For \code{get_season_data}, the host
region affects the data you will receive (i.e. different regions will result in different data).
Must be one of "us", "eu", "kr", "tw", "cn". For more information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides start and ending times for a given season.
}
\note{
Season data is only available for season 28 and higher.
}
\examples{
\donttest{
# Get season start and end times for season 35 in the European region.
try({
    data <- get_season_data(season_id = 35, host_region = "eu")
    as.POSIXct(data$start_timestamp, origin = "1970-01-01")
    as.POSIXct(data$end_timestamp, origin = "1970-01-01")
})
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
Other game data API calls: 
\code{\link{get_ladder_data}()},
\code{\link{get_league_data}()}
}
\concept{game data API calls}
