% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barwithucl.R
\name{barwithucl}
\alias{barwithucl}
\title{barwithucl}
\usage{
barwithucl(
  x,
  iobs,
  ucl,
  plotname = "",
  ylabelname = "",
  xlabelname = "Obs. Index"
)
}
\arguments{
\item{x}{vector with the values of the statistic.}

\item{iobs}{index of the observations whose value will be displayed.}

\item{ucl}{Upper Control Limit of the statistic.}

\item{plotname}{string with the title of the plot. Set to \code{""} by default.}

\item{ylabelname}{string with the y-axis label. Set to \code{""} by default.}

\item{xlabelname}{string with the y-axis label. Set to \code{"Obs. Index"} by default.}
}
\value{
ggplot object with the individual value of a variable as a geom_col
with an horizontal line reference.
}
\description{
Single bar plot with Upper Control Limis. Customized title and labels.
Y-Axis limits are fixed according to the range of the values in x.
}
\examples{
barwithucl(c(1:10), 6, 5)
barwithucl(c(1:10), 6, 5, plotname = "Plot title", ylabelname = "Y label", 
xlabelname= "X label")
}
