% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distplot.R
\name{distplot}
\alias{distplot}
\title{distplot}
\usage{
distplot(
  X,
  pcaref,
  obstag = matrix(0, nrow(X), 1),
  plottitle = "Distance plot\\n"
)
}
\arguments{
\item{X}{data matrix with observations to be displayed in the distance plot.}

\item{pcaref}{list with the information of the PCA model.}

\item{obstag}{Optional column vector of integers indicating the group of each
observation (\code{0} or \code{1}). Default value set to \code{matrix(0, nrow(X), 1)}.}

\item{plottitle}{Optional string with the plot title. Set to \code{"Distance plot"}
by default.}
}
\value{
ggplot object with the distance plot.
}
\description{
Returns the distance plot providing a dataset and a Principal Component Analysis model.
}
\details{
Coordinates are expressed in terms of the Hotelling's T^2 (x-axis) and the Squared
Prediction Error (y-axis) obtained projecting X on the provided model.
Observations can be identified by the obstag input argument.
}
\examples{
X <- as.matrix(X)
pcamodel.ref <- pcamb_classic(X, 2, 0.05, "cent")
distplot(X, pcamodel.ref)
tags <- dotag(X[1:40,], X[-c(1:40),])
distplot(X, pcamodel.ref, obstag = tags, plottitle = "D plot title")
}
