% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cma.R
\name{prepare_pupil_fpca}
\alias{prepare_pupil_fpca}
\title{Prepare Pupil FPCA Dataset}
\usage{
prepare_pupil_fpca(input_data, k_mean = 30, k_fpca = 15, example = "original")
}
\arguments{
\item{input_data}{Raw pupil data}

\item{k_mean}{Number of basis functions for mean model smooth terms (default: 30)}

\item{k_fpca}{Number of knots for FPCA estimation (default: 15)}

\item{example}{Choice for different model. If \code{example = "original"}, will only
include use as the only covariate. If \code{example = "original"}, will include
use, age and gender as covariates.}
}
\value{
A tibble containing:
\itemize{
\item Original pupil variables
\item FPCA eigenfunctions (Phi1, Phi2,...)
\item Sorted by ID and domain
}
}
\description{
Processes data by fitting a mean GAM model, extracting residuals, performing FPCA,
and merging the results to create an enhanced dataset for functional regression analysis.
}
\examples{
if (requireNamespace("mgcv", quietly = TRUE)) {
data(pupil)
\donttest{processed_data <- prepare_pupil_fpca(pupil)}

processed_data <- prepare_pupil_fpca(pupil, k_mean = 5, k_fpca = 5)
}

}
