#'artifratio data
#'
#' 
#' Values from all possible SRSs for an artificial population in Chapter 4 of SDA.
#'
#'
#' @format This data frame contains the following columns:
#' 
#'\describe{
#'  \item{sample:}{sample number}
#'   
#'  \item{i1:}{first unit in sample}
#'     
#'  \item{i2:}{second unit in sample}
#'      
#'   \item{i3:}{third unit in sample}
#'        
#'   \item{i4:}{fourth unit in sample}
#'   
#' \item{xbars:}{\eqn{\bar{x}_s}}          
#'       
#'\item{ybars:}{\eqn{\bar{y}_s}}            
#'
#'\item{bhat:}{\eqn{\widehat{B}}}  
#'
#'\item{tSRS:}{\eqn{\widehat{t}_{y,srs}=N*\bar{y}_s}}
#'
#'\item{thatr:}{\eqn{\widehat{t}_{yr}}}
#'}
#'
#' @docType data
#'
#' @usage data(artifratio)
#'
#'
#'
#' @keywords datasets
#'
#' @references Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.
#' 
#'@references Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press.
#' 
#'
#' 
#' 
#' 
"artifratio"

