% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sei.R
\name{plot_sei}
\alias{plot_sei}
\title{Plot standardised indices}
\usage{
plot_sei(
  x,
  type = c("ts", "hist", "bar"),
  title = NULL,
  lab = "Std. Index",
  xlims = NULL,
  ylims = NULL,
  n_bins = 30
)
}
\arguments{
\item{x}{vector or xts object containing the indices to be plotted.}

\item{type}{type of plot (either time series "ts", histogram "hist", or barplot "bar").}

\item{title}{optional title of the plot.}

\item{lab}{axis label.}

\item{xlims, ylims}{lower and upper limits of the axes.}

\item{n_bins}{the number of bins to show in the histogram.}
}
\value{
A ggplot object displaying the standardised index values.
}
\description{
Plot a time series or histogram of standardised indices.
}
\details{
The \code{plot_sei()} function can be used to plot either a time series (if \code{type = "ts"})
or a histogram (if \code{type = "hist"} or \code{type = "bar"}) of the values in \code{x}.

A time series can only be displayed if \code{x} is an \pkg{xts} time series.

The argument \code{lab} is a string containing the label of the x-axis if
\code{type = "hist"} or \code{type = "bar"} and the y-axis if \code{type = "ts"}.

The options \code{type = "hist"} and \code{type = "bar"} both display histograms
of the data \code{x}. With \code{type = "hist"}, \code{plot_sei()} is essentially a
wrapper of \code{geom_histogram()}, while \code{type = "bar"} is a wrapper of
\code{geom_bar()}. The latter can provide more flexibility when plotting bounded data,
whereas the former is easier to use when superimposing densities on top.
}
\examples{
data(data_supply)
# consider hourly German energy supply data in 2019
supply_de <- subset(data_supply, country == "Germany", select = c("date", "PWS"))
supply_de <- xts::xts(supply_de$PWS, order.by = supply_de$date)
supply_de_std <- std_index(supply_de, timescale = "hours")

plot_sei(supply_de, title = "German renewable energy production in 2019")
plot_sei(supply_de_std, title = "German SREPI in 2019")

plot_sei(supply_de, type = "hist", title = "German renewable energy production in 2019")
plot_sei(supply_de_std, type = "hist", title = "German SREPI in 2019")

# type = "hist" and type = "bar both output a histogram of the index values
# type = "hist" can be useful to superimpose densities on top of the histogram
z <- seq(-3.5, 3.5, length.out = length(supply_de_std))
plot_sei(supply_de_std, type = "hist", title = "German SREPI in 2019") +
 ggplot2::geom_line(ggplot2::aes(x = z, y = dnorm(z)), col = "blue")

# type = "bar" can be useful when the index values are bounded
supply_de_std <- std_index(supply_de, timescale = "hours", index_type = "prob11")
plot_sei(supply_de_std, type = "hist", xlims = c(-1, 1), title = 'type = "hist"')
plot_sei(supply_de_std, type = "bar", xlims = c(-1, 1), title = 'type = "bar"')


}
\author{
Sam Allen, Noelia Otero
}
