% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LatentDigraph.R
\name{getTrekSystem}
\alias{getTrekSystem}
\alias{getTrekSystem.LatentDigraphFixedOrder}
\alias{getTrekSystem.LatentDigraph}
\title{Determines if a trek system exists in the mixed graph.}
\usage{
getTrekSystem(
  this,
  fromNodes,
  toNodes,
  avoidLeftNodes = integer(0),
  avoidRightNodes = integer(0),
  avoidLeftEdges = integer(0),
  avoidRightEdges = integer(0),
  ...
)

\method{getTrekSystem}{LatentDigraphFixedOrder}(
  this,
  fromNodes,
  toNodes,
  avoidLeftNodes = integer(0),
  avoidRightNodes = integer(0),
  avoidLeftEdges = integer(0),
  avoidRightEdges = integer(0),
  ...
)

\method{getTrekSystem}{LatentDigraph}(
  this,
  fromNodes,
  toNodes,
  avoidLeftNodes = integer(0),
  avoidRightNodes = integer(0),
  avoidLeftEdges = integer(0),
  avoidRightEdges = integer(0),
  ...
)
}
\arguments{
\item{this}{the graph object}

\item{fromNodes}{the start nodes}

\item{toNodes}{the end nodes}

\item{avoidLeftNodes}{a collection of nodes to avoid on the left}

\item{avoidRightNodes}{a collection of nodes to avoid on the right}

\item{avoidLeftEdges}{a collection of edges between observed nodes
in the graph that should not be used on any right
hand side of any trek in the trek system.}

\item{avoidRightEdges}{a collection of edges between observed noes
in the graph that should not be used on any right
hand side of any trek in the trek system.}

\item{...}{ignored}
}
\description{
Determines if a trek system exists in the mixed graph.
}
