#' The RICA dataset describing the production of carrots (open field) (in quintals) from 2000 to 2015.
#'
#' A subset of data from the `agreste` French governmental website <https://agreste.agriculture.gouv.fr/agreste-web/servicon/I.2/listeTypeServicon/>.
#'
#'
#' @format `ricaCarrots`
#'
#' A List of 3 objects:
#' \describe{
#'   \item{Y}{a vector. The production of carrots (open field) (in quintals) for 598 French farms.}
#'   \item{X}{a matrix. The 259 covariates describing the same 598 French farms.}
#'   \item{description}{a matrix. Description of the 259 covariates.}
#' }
#'
#' @usage data(ricaCarrots)
#'
#' @source <https://agreste.agriculture.gouv.fr/agreste-web/servicon/I.2/listeTypeServicon/>
"ricaCarrots"
