% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgd_qr.R
\name{sgd_qr}
\alias{sgd_qr}
\title{Averaged S-subGD Estimator in Linear Quantile Regression}
\usage{
sgd_qr(
  formula,
  data,
  gamma_0 = NULL,
  alpha = 0.501,
  burn = 1,
  bt_start = NULL,
  qt = 0.5,
  studentize = TRUE,
  no_studentize = 100L,
  intercept = TRUE,
  path = FALSE,
  path_index = c(1)
)
}
\arguments{
\item{formula}{formula. The response is on the left of a ~ operator. The terms are on the right of a ~ operator, separated by a + operator.}

\item{data}{an optional data frame containing variables in the model.}

\item{gamma_0}{numeric. A tuning parameter for the learning rate (gamma_0 x t ^ alpha). Default is NULL and it is determined by the adaptive method in Lee et al. (2023).}

\item{alpha}{numeric. A tuning parameter for the learning rate (gamma_0 x t ^ alpha). Default is 0.501.}

\item{burn}{numeric. A tuning parameter for "burn-in" observations. 
We burn-in up to (burn-1) observations and use observations from (burn) for estimation. Default is 1, i.e. no burn-in.}

\item{bt_start}{numeric. (p x 1) vector, excluding the intercept term. User-provided starting value. Default is NULL. Then, it is estimated by conquer.}

\item{qt}{numeric. Quantile. Default is 0.5.}

\item{studentize}{logical. Studentize regressors. Default is TRUE.}

\item{no_studentize}{numeric. The number of observations to compute the mean and std error for studentization. Default is 100.}

\item{intercept}{logical. Use the intercept term for regressors. Default is TRUE. 
If this option is TRUE, the first element of the parameter vector is the intercept term.}

\item{path}{logical. The whole path of estimation results is out. Default is FALSE.}

\item{path_index}{numeric. A vector of indices to print out the path. Default is 1.}
}
\value{
An object of class \code{"sgdi"}, which is a list containing the following
\describe{
\item{\code{coefficients}}{a vector of estimated parameter values}
\item{\code{path_coefficients}}{The path of coefficients.}
}
}
\description{
Compute the averaged S-subGD (stochastic subgradient) estimator for the coefficients in linear quantile regression.
}
\note{
{The dimension of \code{coefficients} is (p+1) if \code{intercept}=TRUE or p otherwise.}
}
\examples{
n = 1e05
p = 5
bt0 = rep(5,p)
x = matrix(rnorm(n*(p-1)), n, (p-1))
y = cbind(1,x) \%*\% bt0 + rnorm(n)
my.dat = data.frame(y=y, x=x)
sgd.out = sgd_qr(y~., data=my.dat)
}
