% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sgp.cv}
\alias{plot.sgp.cv}
\title{Plots the cross-validation curve from a SGP object}
\usage{
\method{plot}{sgp.cv}(x, log.l = TRUE, highlight = TRUE, col = "firebrick3", ...)
}
\arguments{
\item{x}{A object that was generated with sgp.cv.}

\item{log.l}{A Boolean value that specifies whether the horizontal axis should be on the log scale.}

\item{highlight}{A Boolean value that specifies whether a vertical line should be added at the value where the cross-validation error is minimized.}

\item{col}{Controls the color of the dots.}

\item{\dots}{Other parameters of underlying basic functions.}
}
\value{
A plot object with the cross-validation curve of an SGP.
}
\description{
Plots the cross-validation curve as a function of the lambda values used.
}
\examples{
n <- 100
p <- 12
nr <- 4
g <- paste0("Group ",ceiling(1:p / nr))
X <- matrix(rnorm(n * p), n, p)
b <- c(-3:3)
y_lin <- X[, 1:length(b)] \%*\% b + 5 * rnorm(n)
y_log <- rbinom(n, 1, exp(y_lin) / (1 + exp(y_lin)))

lin_fit <- sgp.cv(X, y_lin, g, type = "linear")
plot(lin_fit, col = "blue")

log_fit <- sgp.cv(X, y_log, g, type = "logit")
plot(log_fit, col = "blue")

}
