% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Method_function.R
\name{INIT}
\alias{INIT}
\title{Initialization Function for the Intercept Parameter}
\usage{
INIT(Y, X, lam_ridge)
}
\arguments{
\item{Y}{The response vector of length \eqn{n}.}

\item{X}{The design matrix of size \eqn{n\times p}.}

\item{lam_ridge}{The tuning parameter for ridge regression.}
}
\value{
A numeric vector of length \eqn{n}, representing the initial estimation for intercept parameter.
}
\description{
This function computes initial values for intercept parameter by solving a ridge regression problem.
}
\examples{
n <- 100
p <- 100
beta <- rep(1,p)
X <- matrix(rnorm(100*100), n, p)
Y <- sample(c(-3,3),n,replace=TRUE,prob=c(1/2,1/2)) +  X\%*\%beta
lam_ridge <- 0.1
alpha_init <- INIT(Y, X, lam_ridge)
}
