% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto.exact.test.R
\name{auto.exact.test}
\alias{auto.exact.test}
\title{Automated exact form test}
\usage{
auto.exact.test(
  ts,
  c,
  d,
  b_time,
  b_timese,
  mp_type,
  ops,
  exact_func,
  m = "MV",
  r = 1,
  s = 1,
  per = 0,
  k = 0,
  upper = 10
)
}
\arguments{
\item{ts}{ts is the data set which is a time series data typically}

\item{c}{the maximum value of number of basis for time input}

\item{d}{the maximum value of number of basis for variate input}

\item{b_time}{type of basis for time input}

\item{b_timese}{type of basis for variate input}

\item{mp_type}{select type of mapping function, "algeb" indicates algebraic mapping on the real line. "logari" represents logarithmic mapping on the real line}

\item{ops}{Criteria for choosing the number of bases are provided by the package, offering four options: "AIC," "BIC," "CV," and "Kfold," each corresponding to a specific Criteria
"AIC" stands for Akaike Information Criterion, "BIC" stands for Bayesian Information Criterion, "CV" represents cross-validation, and "Kfold" corresponds to k-fold cross-validation
for time series data}

\item{exact_func}{A list contains elements that are matrix contain exact functions, which are desired to be tested. The k-th element represents the k-th variable.
The matrix contains values of the exact function within its domain}

\item{m}{the window size for the simultaneous confidence region procedure, with the default being 'MV,' which stands for the Minimum Volatility method}

\item{r}{indicates number of variate}

\item{s}{s is a positive scaling factor, the default is 1}

\item{per}{the percentage for test set used in cross validation option "CV"}

\item{k}{the number of fold used in k-fold cross validation "Kfold"}

\item{upper}{upper The upper bound for the variate basis domain. The default value is 10. When "algeb" or "logari" is chosen, the domain is automatically set from -upper to upper}
}
\value{
A list whose elements are p value of exact form test. Each element in the list represents p-values in the order of variates.
}
\description{
This function utilizes L2 test for the automated execution of exact form tests
with chosen bases.
}
\details{
In the parameter type, this package provides 32 types of bases, including options such as 'Legen' for Legendre polynomials, 'Cheby' for the first kind of Chebyshev polynomials,
'tri' for trigonometric polynomials, 'cos' for cosine polynomials, 'sin' for sine polynomials, and 'Cspli' for the class of spline functions. In the 'Cspli' option, the first input
'c' represents knots plus 2, which correspond to 0 and 1. The term 'or' indicates the order of splines, so the number of basis elements is the number of knots + 2 - 2 plus the number
of the order. When functions automatically choose the number of basis elements for splines, the number is not less than the order of the spline. The package provides 'db1' to 'db20'
for Daubechies1 wavelet basis to Daubechies20 wavelet basis, and 'cf1' to 'cf5' for Coiflet1 wavelet basis to Coiflet5 wavelet basis. The wavelet tables provided by the Sie2nts package
are generated by the Cascade algorithm using a low-pass filter. If exact values of wavelets are required, the Recursion algorithm should be used.
}
\references{
[1] Ding, Xiucai, and Zhou, Zhou. “Estimation and inference for precision matrices of nonstationary time series.” The Annals of Statistics 48(4) (2020): 2455-2477.

[2] Ding, Xiucai, and Zhou, Zhou. “Auto-regressive approximations to non-stationary time series, with inference and applications.” Available online, 2021.

[3] Ding, Xiucai, and Zhou Zhou. "Simultaneous Sieve Inference for Time-Inhomogeneous Nonlinear Time Series Regression." Available online, 2021.
}
