% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sift_filter.R
\name{SIFT_output_filter}
\alias{SIFT_output_filter}
\title{SIFT output filter}
\usage{
SIFT_output_filter(
  setdir = getwd(),
  input_name = file.choose(),
  output_name,
  n_parameters = 2,
  param_names = c("Isoprene", "Acetone"),
  out_file = TRUE
)
}
\arguments{
\item{setdir}{allow the selection of the working directory}

\item{input_name}{allow the selection of the input file}

\item{output_name}{name of the .csv output file}

\item{n_parameters}{number of analytes}

\item{param_names}{vector with name of the analytes}

\item{out_file}{flag for the export of a csv file}
}
\value{
Filtered data and optional csv from SIFT input
}
\description{
This function takes as input the output file generated by the SIFT-MS
and returns a .csv containing the TIME and the concentrations data selected
by the user
}
\examples{
data(raw_SIFT)
SIFT_output_filter(input_name = raw_SIFT, output_name = "testfile", out_file = FALSE)


}
