% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envplot.R
\name{envplot}
\alias{envplot}
\title{Quantile-quantile plots with simulated envelope of residuals for SLRMss objects}
\usage{
envplot(
  object,
  J = 100,
  conf = 0.95,
  seed = NULL,
  H0 = FALSE,
  colors = c("red", "green"),
  pch = 16,
  lty = 2,
  xlab,
  ylab,
  main
)
}
\arguments{
\item{object}{An object of class \code{SLRMss}.}

\item{J}{The number of Monte Carlo replications. 100 by default.}

\item{conf}{The confidence level. 0.95 by default.}

\item{seed}{An optional seed for the simulation.}

\item{H0}{If TRUE, choose the fitted values under null hypothesis, if FALSE, choose the fitted values under alternative hypothesis (default).}

\item{colors}{A vector with one or two characters. If it has one character, that represents the color of the plotted points. If it has two characters, the first one represents the color of the points out of the limits and the second one represents the color of the points under the limits. Red and green by default.}

\item{pch}{A vector with one or two numbers. If it has one numeric, that represents the plot \code{pch}. If it has two numbers, the first one represents the \code{pch} of the points out of the limits and the second one represents the \code{pch} of the points under the limits. 16 by default.}

\item{lty}{A vector with one or two numbers. If it has one number, that represents the \code{lty} of all lines. If it has two numbers, the first one represents the \code{lty} of the middle line and the second one represents the lty of the limits line. 2 by default.}

\item{xlab}{A title for the x axis.}

\item{ylab}{A title for the y axis.}

\item{main}{A title for the plot.}
}
\value{
Quantile-quantile plot with simulated envelope for a SLRMss object.
}
\description{
This function provides an envelope plot of a fitted SLRMss model.
}
\examples{
data(orange)
fit <- SLRMss(emulsion ~ arabicgum + xanthangum + orangeoil, family="Student",
xi=3, testingbeta="xanthangum", statistic="LR", data=orange)
envplot(fit)
}
