% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dispersion.R
\name{plot_dispersion}
\alias{plot_dispersion}
\title{Verify the optimality condition for an optimal design (A-, c- or D-optimality)}
\usage{
plot_dispersion(
  u,
  design,
  tt,
  FUN,
  theta,
  criterion = "D",
  cVec = rep(0, length(theta))
)
}
\arguments{
\item{u}{The discretized design points}

\item{design}{The optimal design containing the design points and the associated weights}

\item{tt}{The level of skewness}

\item{FUN}{The function to calculate the derivative of the given model}

\item{theta}{The parameter value of the model}

\item{criterion}{The optimality criterion: one of "A", "c", or "D"}

\item{cVec}{c vector used to determine the combination of the parameters. This is only used in c-optimality}
}
\value{
A plot verifying the general equivalence condition for the specified optimal design
}
\description{
Verify the optimality condition for an optimal design (A-, c- or D-optimality)
}
\details{
This function visualizes the directional derivative under A-, c-, or D-optimality using the general equivalence theorem. For an optimal design, the directional derivative should not exceed the reference threshold
}
\examples{
poly3 <- function(xi, theta){
  matrix(c(1, xi, xi^2, xi^3), ncol = 1)
}
design_A <- data.frame(location = c(-1, -0.464, 0.464, 1),
                       weight = c(0.151, 0.349, 0.349, 0.151))
design_D = data.frame(location = c(-1, -0.447, 0.447, 1),
                      weight = rep(0.25, 4))
u <- seq(-1, 1, length.out = 201)
par(mfrow = c(2,2))
plot_dispersion(u, design_A, tt = 0, FUN = poly3, theta = rep(0, 4), criterion = "A")
plot_dispersion(u, design_A, tt = 0, FUN = poly3, theta = rep(0, 4), criterion = "D")

plot_dispersion(u, design_D, tt = 0, FUN = poly3, theta = rep(0, 4), criterion = "A")
plot_dispersion(u, design_D, tt = 0, FUN = poly3, theta = rep(0, 4), criterion = "D")

}
