% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_PrecisionRecallCurve.R
\name{auc.pr.curve}
\alias{auc.pr.curve}
\alias{weighted.auc.pr.curve}
\title{Area under the Precision Recall Curve}
\usage{
## Generic S3 method
## for Area under the Precision Recall Curve
auc.pr.curve(...)

## Generic S3 method for
## unweighted area under the
## Precision Recall Curve
auc.pr.curve(...)

## Generic S3 method
## for weighted Area under the Precision Recall Curve
weighted.auc.pr.curve(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=auc.pr.curve.factor]{auc.pr.curve.factor}}, \code{\link[=weighted.auc.pr.curve.factor]{weighted.auc.pr.curve.factor}}
  \describe{
    \item{\code{actual}}{A vector \link{length} \eqn{n}, and \eqn{k} levels. Can be of \link{integer} or \link{factor}.}
    \item{\code{response}}{A \eqn{n \times k} <\link{double}>-matrix of predicted probabilities.
The \eqn{i}-th row should sum to 1 (i.e., a valid probability distribution
over the \eqn{k} classes). The first column corresponds to the first factor
level in \code{actual}, the second column to the second factor level, and so on.}
    \item{\code{method}}{A <\link{double}> value (default: \eqn{0}). Defines the underlying method of calculating the area under the curve. If \eqn{0} it is calculated using the \code{trapezoid}-method, if \eqn{1} it is calculated using the \code{step}-method.}
    \item{\code{indices}}{An optional \eqn{n \times k} matrix of <\link{integer}> values of sorted response probability indices.}
    \item{\code{estimator}}{An <\link{integer}>-value of \link{length} \eqn{1} (default: \eqn{0}).
\itemize{
\item 0 - a named <\link{double}>-vector of \link{length} k (class-wise)
\item 1 - a <\link{double}> value (Micro averaged metric)
\item 2 - a <\link{double}> value (Macro averaged metric)
}}
    \item{\code{w}}{A <\link{double}> vector of sample weights.}
  }}
}
\value{
If \code{estimator} is given as
\itemize{
\item 0: a named <\link{double}>-vector of \link{length} k
\item 1: a <\link{double}> value (Micro averaged metric)
\item 2: a <\link{double}> value (Macro averaged metric)
}
}
\description{
A generic S3 function to compute the \emph{area under the precision recall curve} score for a classification model. This function dispatches to S3 methods in \code{\link[=auc.pr.curve]{auc.pr.curve()}} and performs no input validation. If you supply \link{NA} values or vectors of unequal \link{length} (e.g. \code{length(x) != length(y)}), the underlying \code{C++} code may trigger undefined behavior and crash your \code{R} session.
\subsection{Defensive measures}{

Because \code{\link[=auc.pr.curve]{auc.pr.curve()}} operates on raw pointers, pointer-level faults (e.g. from \link{NA} or mismatched \link{length}) occur before any \code{R}-level error handling.  Wrapping calls in \code{\link[=try]{try()}} or \code{\link[=tryCatch]{tryCatch()}} will \emph{not} prevent \code{R}-session crashes.

To guard against this, wrap \code{\link[=auc.pr.curve]{auc.pr.curve()}} in a "safe" validator that checks for \link{NA} values and matching \link{length}, for example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{safe_auc.pr.curve <- function(x, y, ...) \{
  stopifnot(
    !anyNA(x), !anyNA(y),
    length(x) == length(y)
  )
  auc.pr.curve(x, y, ...)
\}
}\if{html}{\out{</div>}}

Apply the same pattern to any custom metric functions to ensure input sanity before calling the underlying \code{C++} code.
}

\subsection{Visualizing area under the precision recall curve}{

Use \code{\link[=pr.curve]{pr.curve()}} to construct the \link{data.frame} and use \link{plot} to visualize the area under the curve.
}

\subsection{Efficient multi-metric evaluation}{

To avoid sorting the same probability matrix multiple times (once per class or curve), you can precompute a single set of sort indices and pass it via the \code{indices} argument. This reduces the overall cost from O(K·N log N) to O(N log N + K·N).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## presort response
## probabilities
indices <- preorder(response, decreasing = TRUE)

## evaluate area under the precision recall curve
auc.pr.curve(actual, response, indices = indices)
}\if{html}{\out{</div>}}
}
}
\examples{
## Classes and
## seed
set.seed(1903)
classes <- c("Kebab", "Falafel")

## Generate actual classes
## and response probabilities
actual_classes <- factor(
    x = sample(
      x = classes, 
      size = 1e2, 
      replace = TRUE, 
      prob = c(0.7, 0.3)
    )
)

response_probabilities <- ifelse(
    actual_classes == "Kebab", 
    rbeta(sum(actual_classes == "Kebab"), 2, 5), 
    rbeta(sum(actual_classes == "Falafel"), 5, 2)
)

## Construct response
## matrix
probability_matrix <- cbind(
    response_probabilities,
    1 - response_probabilities
)

## Calculate area under the precision recall curve

SLmetrics::auc.pr.curve(
    actual   = actual_classes, 
    response = probability_matrix
)

}
\references{
James, Gareth, et al. An introduction to statistical learning. Vol. 112. No. 1. New York: springer, 2013.

Hastie, Trevor. "The elements of statistical learning: data mining, inference, and prediction." (2009).

Pedregosa, Fabian, et al. "Scikit-learn: Machine learning in Python." the Journal of machine Learning research 12 (2011): 2825-2830.
}
\seealso{
Other Classification: 
\code{\link{accuracy}()},
\code{\link{auc.roc.curve}()},
\code{\link{baccuracy}()},
\code{\link{brier.score}()},
\code{\link{ckappa}()},
\code{\link{cmatrix}()},
\code{\link{cross.entropy}()},
\code{\link{dor}()},
\code{\link{fbeta}()},
\code{\link{fdr}()},
\code{\link{fer}()},
\code{\link{fmi}()},
\code{\link{fpr}()},
\code{\link{hammingloss}()},
\code{\link{jaccard}()},
\code{\link{logloss}()},
\code{\link{mcc}()},
\code{\link{nlr}()},
\code{\link{npv}()},
\code{\link{plr}()},
\code{\link{pr.curve}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{relative.entropy}()},
\code{\link{roc.curve}()},
\code{\link{shannon.entropy}()},
\code{\link{specificity}()},
\code{\link{zerooneloss}()}

Other Supervised Learning: 
\code{\link{accuracy}()},
\code{\link{auc.roc.curve}()},
\code{\link{baccuracy}()},
\code{\link{brier.score}()},
\code{\link{ccc}()},
\code{\link{ckappa}()},
\code{\link{cmatrix}()},
\code{\link{cross.entropy}()},
\code{\link{deviance.gamma}()},
\code{\link{deviance.poisson}()},
\code{\link{deviance.tweedie}()},
\code{\link{dor}()},
\code{\link{fbeta}()},
\code{\link{fdr}()},
\code{\link{fer}()},
\code{\link{fmi}()},
\code{\link{fpr}()},
\code{\link{gmse}()},
\code{\link{hammingloss}()},
\code{\link{huberloss}()},
\code{\link{jaccard}()},
\code{\link{logloss}()},
\code{\link{maape}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mcc}()},
\code{\link{mpe}()},
\code{\link{mse}()},
\code{\link{nlr}()},
\code{\link{npv}()},
\code{\link{pinball}()},
\code{\link{plr}()},
\code{\link{pr.curve}()},
\code{\link{precision}()},
\code{\link{rae}()},
\code{\link{recall}()},
\code{\link{relative.entropy}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{roc.curve}()},
\code{\link{rrmse}()},
\code{\link{rrse}()},
\code{\link{rsq}()},
\code{\link{shannon.entropy}()},
\code{\link{smape}()},
\code{\link{specificity}()},
\code{\link{zerooneloss}()}
}
\concept{Classification}
\concept{Machine learning}
\concept{Performance evaluation}
\concept{Statistical learning}
\concept{Supervised Learning}
\keyword{classification}
\keyword{evaluation}
\keyword{regression}
