% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogOR.R
\name{LogOR}
\alias{LogOR}
\title{Log-Odds Ratios for Embedded Dynamic Treatment Regimes}
\usage{
LogOR(
  response_prob = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8),
  stage_one_trt_one_response_prob = 0.6,
  stage_one_trt_two_response_prob = 0.3,
  stage_one_trt_three_response_prob = 0.4,
  design = "general"
)
}
\arguments{
\item{response_prob}{the probability of response for each of embedded treatment sequences. In the case of the design 1 SMART, there are 6,
for the general design there are 8, and for Design-3 there are 9 embedded treatment sequences.}

\item{stage_one_trt_one_response_prob}{the probability of response to stage-1 treatment given stage-1 treatment one.}

\item{stage_one_trt_two_response_prob}{the probability of response to stage-1 treatment given stage-1 treatment two.}

\item{stage_one_trt_three_response_prob}{the probability of response to stage-1 treatment given stage-1 treatment three (for design-3 only)}

\item{design}{which SMART design: design-1 (ENGAGE-type), general, or design-3.}
}
\value{
The embedded dynamic treatment regime specific log-OR.
}
\description{
Computes the embedded dynamic treatment regime specific log-odds ratios.
}
