% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.functions.R
\name{comp.trans.mat}
\alias{comp.trans.mat}
\title{Compute transition matrix}
\usage{
comp.trans.mat(SOM, start = 1)
}
\arguments{
\item{SOM}{a kohonen object on which transitions between neurons will be computed}

\item{start}{a vector containing the start frames of each replica (usually contained in trj$start if replicas were merged with cat_trj)}
}
\value{
A matrix of pairwise transitions between neurons
}
\description{
Compute the transition matrix starting from a vector of subsequent classifications
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Compute transition Matrix
tr_mat <- comp.trans.mat(som_model, start = 1)
}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
