% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.add.circles.R
\name{som.add.circles}
\alias{som.add.circles}
\title{Add circles to SOM}
\usage{
som.add.circles(SOM, P, scale = 1, col.circles = "white")
}
\arguments{
\item{SOM}{the SOM object}

\item{P}{a vector containing the per-neuron property to plot}

\item{scale}{a number to scale up or down the size of the drawn circles}

\item{col.circles}{the background color of the drawn circles}
}
\value{
Called for its effect.
}
\description{
Function to add circles to a SOM plot, with dimension proportional to a selected property
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
# Compute per neuron population
pop <- neur.population(som_model)
#Plot the som
plot(som_model, type = "count", bgcol=c("red", "blue", "yellow", "green"), shape='straight')
# Add circles to the SOM plot
som.add.circles(som_model, pop, scale=0.9)

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
