% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.path.R
\name{trace.path}
\alias{trace.path}
\title{Trace pathway}
\usage{
trace.path(
  SOM,
  start = 1,
  end = length(SOM$unit.classif),
  N = 1,
  draw.stride = 1,
  pts.scale = 1,
  lwd.scale = 1
)
}
\arguments{
\item{SOM}{the SOM object}

\item{start}{a vector containing the start frames of each replica (usually contained in trj$start if replicas were merged with cat_trj)}

\item{end}{a vector containing the end frames of each replica (usually contained in trj$end if replicas were merged with cat_trj)}

\item{N}{The portion of simulation that one want to plot}

\item{draw.stride}{used to plot the pathways with a stride (useful for very complex pathways)}

\item{pts.scale}{a number to scale up or down the size of the circles}

\item{lwd.scale}{a number to scale up or down the size of the lines}
}
\value{
Called for its effect.
}
\description{
Function trace pathway sampled on the SOM
}
\examples{
# Read the trajectory
trj <- read.trj(trjfile = system.file("extdata", "HIF2a-MD.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#trace pathway sampled on the SOM
trace.path(som_model, start=trj$start, end=trj$end, N=1, pts.scale=0.5)

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
