% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoology_description.R,
%   R/zoology_description_type.R
\name{zoology_description}
\alias{zoology_description}
\alias{zoology_description_type}
\title{Query details of species in China Animal Scientific Database}
\usage{
zoology_description(query, dbname, destype)

zoology_description_type(query, dbname)
}
\arguments{
\item{query}{\code{string} The string to query for scientific names.}

\item{dbname}{\code{integer} There is one required parameter, a single numeric that indicates which China animal scientific database to use. Details in \code{\link{zoology_dbase_name}}  for the list of available databases.}

\item{destype}{\code{integer} There is one required parameter, a single numeric that indicates which description type information to use. Details in \code{\link{zoology_description}}  for the list of available description type information based on the species name and database name.}
}
\value{
details of species in China Animal Scientific Database

description type information
}
\description{
Query the description information based on the species name, database name, and description type.

Query the description type information based on the species name and database name.
}
\details{
Visit the website \url{http://zoology.especies.cn} for more details.

Visit the website \url{http://zoology.especies.cn} for more details.
}
\examples{
\dontrun{
##Set your key
set_search_key("your apiKey",db = "zoology")

##Query details of species in Chinese Bird Database
zoology_description(query = "Aix galericulata",dbname = 4,destype = 209)
}
\dontrun{
##Set your key
set_search_key("your apiKey",db = "zoology")

##Query description type information of Chinese Bird Database
zoology_description_type(query = "Aix galericulata",dbname = 4)
}
}
\author{
Liuyong Ding \email{ly_ding@126.com}

Liuyong Ding \email{ly_ding@126.com}
}
