% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{drawperson}
\alias{drawperson}
\title{drawperson}
\usage{
drawperson(
  xloc = 0,
  yloc = 0,
  scale = 1,
  headsize = 0.16,
  headangle = pi/8,
  headloc = 0.5,
  necklength = 0.1,
  shoulderwidth = 0.1,
  shouldersize = 0.05,
  armlength = 0.4,
  armangle = 7 * pi/8,
  armwidth = 0.08,
  leglength = 0.5,
  legangle = 9 * pi/10,
  legwidth = 0.15,
  torsolength = 0.4,
  ...
)
}
\arguments{
\item{xloc}{x-axis offset from origin}

\item{yloc}{y-axis offset from origin}

\item{scale}{scale upwards from 1x1 box}

\item{headsize}{head size}

\item{headangle}{half angle of neck in terms of head}

\item{headloc}{location of centre of head relative to origin with scale 1}

\item{necklength}{neck length}

\item{shoulderwidth}{shoulder width}

\item{shouldersize}{size radius of arc for shoulder}

\item{armlength}{arm length}

\item{armangle}{angle of arm from horizontal}

\item{armwidth}{width of arm}

\item{leglength}{leg length}

\item{legangle}{angle of leg from horizontal}

\item{legwidth}{width of leg}

\item{torsolength}{length of torso}

\item{...}{other parameters passed to polygon()}
}
\value{
invisibly returns co-ordinates
}
\description{
Draws a simple stock image of a person.
}
\details{
Draws a figure at a particular location. With defaults, has centre at origin and fits in 1x1 box.

Dimensions customisable
}
\examples{
plot(0,xlim=c(-1,1),ylim=c(-1,1),type="n")
drawperson(0,0,1,col="yellow",border="red",lwd=3,lty=2)
}
