% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parglo.maxlik.R
\name{Generalized-Logistic}
\alias{Generalized-Logistic}
\alias{parglo.maxlik}
\title{Generalized Logistic maximum likelihood function}
\usage{
parglo.maxlik(x, ini)
}
\arguments{
\item{x}{vector of quantiles for which to evaluate the PDF.}

\item{ini}{a vector of initial values of the parameters to be fit.}
}
\value{
a list of parameters of a generalized Logistic
distribution function
}
\description{
Maximum likelihood fitting function for
generalized logistic distribution.
}
\details{
This function is used internally by \code{spei}
and \code{spi} and is supposed to never be needed by the
regular user. Initial values for maximum likelihood estimation
can be provided by \code{parglo}.
}
\references{
S.M. Vicente-Serrano, S. Beguería, J.I. López-Moreno. 2010.
A Multi-scalar drought index sensitive to global warming:
The Standardized Precipitation Evapotranspiration Index – SPEI.
\emph{Journal of Climate} \bold{23}: 1696, DOI: 10.1175/2009JCLI2909.1.
}
\author{
Santiago Beguería
}
