#' Scar heights
#'
#' Scar heights for men and women.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 4 rows (each combination) and 3 columns:
#' \describe{
#'   \item{Counts}{The number of people with the given combination}
#'   \item{Gender}{The gender of the person; one of \code{Women} or \code{Men}}
#'   \item{ScarHt}{The scar height;
#'         one of \code{0mm} (i.e., smooth) or \code{1mm} (i.e., 0mm to 1mm) }
#' }
#' @source 
#' Wallace, Hilary J., Mark W. Fear, Margaret M. Crowe, Lisa J. Martin, 
#' and Fiona M. Wood.2017. 
#' Identification of Factors Predicting Scar Outcome After Burn in Adults: 
#' A Prospective Case-Control Study. 
#' \emph{Burns} \bold{43}: 1271--83
#' 
#' @usage 
#' data(ScarHeight)
#' 
#' @examples
#' barplot( xtabs(Counts ~ ScarHt + Gender, data = ScarHeight), ylab = "Number of people")
#' 

"ScarHeight"
