% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dogs.R
\docType{data}
\name{Dogs}
\alias{Dogs}
\title{Dog measurements}
\format{
A data frame with 30 rows (one per dog) and 4 columns:
\describe{
  \item{BL}{Body length, in cm}
  \item{BH}{Body height, in cm}
  \item{Chest}{Chest measurement, in cm}
  \item{Waist}{Waist measurement, in cm}
}
}
\source{
Quan, Quoc-Dang, Hoang-Dung Tran, and Anh-Dung Chung. 2017. 
The Relation of Body Score (Body Height/Body Length) and 
Haplotype E on Phu Quoc Ridgeback Dogs (Canis Familiaris).
\emph{Journal of Entomology and Zoology Studies} \bold{5}: 388--94
}
\usage{
data(Dogs)
}
\description{
Measurements of Phu Quoc Ridgeback dogs.
}
\examples{
plot(BL ~ BH, data = Dogs, xlab = "Height (cm)", ylab = "Length (cm)")

}
\keyword{datasets}
