% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_FMM_SemiSupervised.R
\name{EM_FMM_SemiSupervised}
\alias{EM_FMM_SemiSupervised}
\title{EM for Semi-Supervised FMM with a Mixed-Missingness Mechanism (MCAR + entropy-based MAR)}
\usage{
EM_FMM_SemiSupervised(
  data,
  g = 2,
  init_res,
  max_iter = 5,
  tol = 1e-06,
  ncov = 1,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame or matrix with \eqn{p+2} columns:
first \eqn{p} are features, then \code{missing} (0 = labelled, 1 = unlabelled),
and \code{z} (class label for labelled rows; ignored otherwise).}

\item{g}{Integer, number of mixture components (classes).}

\item{init_res}{A list with initial parameters:
\itemize{
\item \code{pi}: numeric length-\code{g} (mixture weights, sum to 1)
\item \code{mu}: list of length \code{g}, each length-\code{p} mean vector
\item \code{Sigma}: if \code{ncov = 1}, a \code{p x p} matrix;
if \code{ncov = 2}, a list of \code{g} \code{p x p} matrices
\item \code{alpha}: scalar in (0,1)
\item \code{xi}: numeric length-2, logistic coefficients \code{(xi0, xi1)}
}}

\item{max_iter}{Integer, max EM iterations.}

\item{tol}{Convergence tolerance on log-likelihood increase.}

\item{ncov}{Integer covariance structure: \code{1} = shared/equal,
\code{2} = class-specific/unequal.}

\item{verbose}{Logical; if \code{TRUE}, progress messages are printed
using \code{message()}. Default is \code{FALSE}.}
}
\value{
A list with elements:
\code{pi}, \code{mu}, \code{Sigma}, \code{xi}, \code{alpha}, \code{loglik},
and \code{ncov}.
}
\description{
Runs an EM-like procedure that models a mixed-missingness mechanism:
unlabeled indicator \eqn{m_j} follows a mixed-missingness mechanism with MCAR (prob \eqn{\alpha})
and entropy-based MAR via a logistic link \eqn{q_j = \text{logit}^{-1}(\xi_0 + \xi_1 \log e_j)}.
Supports shared (\code{ncov = 1}) or class-specific (\code{ncov = 2}) covariance.
}
\details{
This function expects the following helpers to be available:
\itemize{
\item \code{pack_theta(pi_k, mu_k, Sigma_k, g, p, ncov)}
\item \code{unpack_theta(theta, g, p, ncov)}
\item \code{neg_loglik(theta, Y_all, m_j, Z_all, d2_yj, xi, alpha_k, unpacker)}
\item \code{get_entropy(dat, n, p, g, paralist)} returning per-observation
entropy-like values
}
}
\examples{
\donttest{
  ## Toy example using a simple partially-labelled dataset
  set.seed(1)

  ## 1) Construct an n x (p+2) partially-labelled dataset:
  ##    first p columns = features, then 'missing' and 'z'
  n <- 100; p <- 2; g <- 2

  X <- matrix(rnorm(n * p), nrow = n, ncol = p)

  ## missing: 0 = labelled, 1 = unlabelled
  missing <- rbinom(n, size = 1, prob = 0.3)

  ## z: observed class labels for labelled rows, NA for unlabelled
  z <- rep(NA_integer_, n)
  z[missing == 0] <- sample(1:g, sum(missing == 0), replace = TRUE)

  sim_dat <- data.frame(X, missing = missing, z = z)

  ## 2) Warm-up initialisation using the complete-data initializer
  init <- EM_FMM_SemiSupervised_Complete_Initial(
    data = sim_dat,
    g    = g,
    ncov = 1
  )

  ## 3) Run the main EM algorithm (small number of iterations)
  fit <- EM_FMM_SemiSupervised(
    data     = sim_dat,
    g        = g,
    init_res = init,
    ncov     = 1,
    max_iter = 5,
    verbose  = FALSE
  )

  str(fit)
}

}
