% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSM_class.R
\docType{class}
\name{SSM-class}
\alias{SSM}
\alias{SSM-class}
\title{An S4 class to represent a smooth supersaturated model}
\description{
An S4 class to represent a smooth supersaturated model
}
\section{Slots}{

\describe{
\item{\code{dimension}}{A number indicating the number of variables in the design.}

\item{\code{design}}{A matrix with rows indicating the design point and columns
indicating the variable.}

\item{\code{design_size}}{A number indicating the number of design points.}

\item{\code{response}}{A \code{design_size} length vector of responses.}

\item{\code{theta}}{A vector containing the fitted model coefficients.}

\item{\code{basis}}{A matrix with each row being the exponent vector of a polynomial
term.}

\item{\code{basis_size}}{A number indicating the number of basis terms used in the
model.  This may be different from \code{nrow(basis)} if terms are excluded.}

\item{\code{include}}{A vector containing the row numbers of the basis polynomials
used in the model.  This is used when interactions or variables are being
excluded from the model.}

\item{\code{K}}{A semi-positive definite matrix that defines the smoothing criteria.}

\item{\code{P}}{A matrix that defines the polynomial basis in terms of a monomial
basis.}

\item{\code{design_model_matrix}}{A matrix.}

\item{\code{variances}}{A vector of length \code{basis_size} containing the term
variances.}

\item{\code{total_variance}}{A length one vector containing the total variance.}

\item{\code{main_sobol}}{A \code{dimension} length vector containing the Sobol
index for each variable.}

\item{\code{main_ind}}{A logical matrix indicating whether each term is included
in the main effect corresponding to the column.}

\item{\code{total_sobol}}{A \code{dimension} length vector containing the Total
sensitivity index for each variable.}

\item{\code{total_ind}}{A logical matrix indicating whether each term is included in
the Total sensitivity index corresponding to the column.}

\item{\code{int_sobol}}{A vector containing the Sobol index for interactions.}

\item{\code{int_factors}}{A list of length the same as \code{int_sobol} indicating
which interaction corresponds with each entry in \code{int_sobol}.}

\item{\code{total_int}}{A vector containing the Total interaction indices of all
second order interactions.}

\item{\code{total_int_factors}}{A matrix where each row indicates the variables
associated with the corresponding interaction in \code{total_int}.}

\item{\code{distance}}{A matrix containing the distances used for computing the
covariance matrix of the GP metamodel error estimate.}

\item{\code{distance_type}}{A character defining the distance type used for computing
\code{distance}.  Can be one of "distance", "line", "product", "area",
"proddiff", or "smoothdiff".}

\item{\code{type}}{A character, either "exp", "matern32", that selects the
correlation function used for the GP metamodel error estimate.}

\item{\code{covariance}}{A positive definite matrix.  The covariance matrix of the GP
metamodel error estimate prior to scaling by \code{sigma}.}

\item{\code{residuals}}{A \code{design_size} length vector containing the
Leave-One-Out errors of the model at each design point.}

\item{\code{sigma}}{A number indicating the scaling factor for \code{covariance}.}

\item{\code{r}}{A number indicating the length factor for the correlation function.}

\item{\code{local_smoothness}}{A \code{design_size} length vector containing the
model smoothness at each design point.}

\item{\code{LOO_RMSE}}{A number. The Leave-One-Out root mean square error.}

\item{\code{legendre}}{logical. Indicates whether the default Legendre polynomial
basis is being used.}

\item{\code{fail}}{logical. Indicates whether the model fit was successful.}
}}

