% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SSM.R
\name{construct.K.1d}
\alias{construct.K.1d}
\title{Construct the K matrix for a given univariate basis.}
\usage{
construct.K.1d(basis)
}
\arguments{
\item{basis}{A matrix.  Rows of the matrix are taken as the degree of the
Legendre polynomial.}
}
\value{
A matrix where each entry is \eqn{<f, g>} with \deqn{<f, g> = \int_X
 \frac{d^2f}{dx^2}\frac{d^2g}{dx^2} dx,} with \eqn{f, g} being the
 Legendre polynomials described by the appropriate exponent vectors.
}
\description{
This function constructs the K matrix for a given multivariate basis assuming
the basis is a Legendre polynomial basis and the smoothing criterion is the
Frobenius norm of the Hessian integrated over \eqn{[-1, 1]}.
}
\keyword{internal}

