% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SSM.R
\name{construct.dmm}
\alias{construct.dmm}
\title{Construct the design model matrix}
\usage{
construct.dmm(basis, design, P)
}
\arguments{
\item{basis}{An \eqn{N x d} matrix where each row is an exponent
vector.}

\item{design}{An \eqn{n x d} matrix where each row is a design point.}

\item{P}{An \eqn{N x N} change of basis matrix from a monomial basis to
a polynomial basis.  Note that each column corresponds to a polynomial term.}
}
\value{
The \eqn{n x N} design model matrix.
}
\description{
Constructs the design model matrix corresponding to the given design and
basis. Used by \code{fit.ssm}.
}
\details{
The argument \code{basis} defines a monomial basis and the change of basis
matrix \code{P} is used to convert this to a polynomial basis.  The function
returns the design model matrix corresponding to this polynomial basis and
the design given by \code{design}.  Note that if \code{P} is the
appropriately sized identity matrix then the model basis a monomial one.
}
\keyword{internal}

