% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SSM.R
\name{transform11}
\alias{transform11}
\title{Transform a design to [-1, 1]^d}
\usage{
transform11(design)
}
\arguments{
\item{design}{A matrix where each row is a design point.}
}
\value{
A matrix where each column contains values in \eqn{[-1, 1]^d}.
}
\description{
This function transforms a design (supplied as a matrix) into the space
[-1, 1]^d.  This has numerical and computational advantages when using smooth
supersaturated models and is assumed by the default \code{\link{fit.ssm}}
behaviour.
}
\examples{
X <- transform11(quakes[, 1:4])
apply(X, 2, range)
}

