% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInhFunc.R
\name{plotInhFunc}
\alias{plotInhFunc}
\title{Plots and prints stop-signal delays and accuracies}
\usage{
plotInhFunc(df, stop_col, ssd_col, acc_col)
}
\arguments{
\item{df}{Dataframe with response time, accuracy, indication whether trial is stop or go, and delays for a given trial.}

\item{stop_col}{Name of the column in the dataframe \code{df} that indicates whether a given trial is a "stop" or a "go" trial ( 0 = go, 1 = stop)}

\item{ssd_col}{Name of the column in the dataframe \code{df} that contains stop-signal delays}

\item{acc_col}{Name of the column in the dataframe \code{df} that contains accuracy of inhibition ( 0 = incorrect, 1 = correct)}
}
\value{
Line plot of the inhibition function.
}
\description{
Plots and prints stop-signal delays and corresponding accuracies. For studies that use fixed (randomly chosen on each trial from a pre-determined set) stop-signal delays.
}
\examples{
data(fixed)
df <- subset(fixed, new_id == 3)
plotInhFunc(df = df, stop_col='vol', ssd_col='soa', acc_col='acc')
}
