% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od_cache.R
\name{od_cache}
\alias{od_cache}
\alias{od_cache_summary}
\alias{od_downloads}
\title{Cache management for Open Data}
\usage{
od_cache_summary(server = "ext")

od_downloads(server = "ext")
}
\arguments{
\item{server}{the OGD-Server to use. \code{"ext"} for the external server (the
default) or \code{"red"} for the editing server}
}
\value{
\itemize{
\item \code{\link[=od_cache_summary]{od_cache_summary()}} provides an overview of all contents of the cache through
a data.frame. It has one row for each dataset and returns a \code{data.frame} with#
the following columns in which all file sizes are given in bytes.
\itemize{
\item \strong{\code{id}} the dataset id
\item \strong{\code{updated}} the last modified time for \verb{$\{id\}.json}
\item \strong{\code{json}} the file size of \verb{$\{id\}.json}
\item \strong{\code{data}} the file size of \verb{$\{id\}.csv}
\item \strong{\code{header}} the file size of \verb{$\{id\}_HEADER.csv}
\item \strong{\code{fields}} the total file size of all files belonging to fields (\verb{\{id\}_C*.csv}).
\item \strong{\code{n_fields}} the number of field files
}
\item \code{\link[=od_downloads]{od_downloads()}} shows a download history for the current cache and returns
a \code{data.frame} with the following columns:
\itemize{
\item \strong{\code{time}} a timestamp for the download
\item \strong{\code{file}} the filename
\item \strong{\code{downloaded}} the download time in milliseconds
}
}
}
\description{
Functions to inspect the contents of the current cache.
}
\examples{
## make sure the cache is not empty
od_table("OGD_krebs_ext_KREBS_1")
od_table("OGD_veste309_Veste309_1")

## inspect
od_cache_summary()
od_downloads()
}
