% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FKPSS_teststat.R
\name{FKPSS_teststat}
\alias{FKPSS_teststat}
\title{Test Statistic in Functional KPSS Test}
\usage{
FKPSS_teststat(X)
}
\arguments{
\item{X}{The functional time series being tested, inputted in a matrix form with each row representing each observation of the functional data values on equidistant points of any prespecified interval.}
}
\value{
The value of test statistic R_N for functional KPSS test.
}
\description{
Calculate test statistic R_N for functional KPSS test, which Was constructed in Kokoszka and Young (2016) and Chen and Pun (2019).
}
\examples{
N<-100
EX<-matrix(rep(0,N*100),ncol=100)
set.seed(1)
for (i in 1:N) {
temp<-rnorm(100,0,1)
EX[i,1]<-temp[1]
for (j in 2:100) {
EX[i,j]<-EX[i,j-1]+temp[j]
}
}
FST_teststat_TN(EX)
}
\references{
Chen, Y., & Pun, C. S. (2019). A bootstrap-based KPSS test for functional time series. Journal of Multivariate Analysis, 174, 104535.

Kokoszka, P., & Young, G. (2016). KPSS test for functional time series. Statistics, 50(5), 957-973.
}
