% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDiag.R
\name{getDiag}
\alias{getDiag}
\title{Extract posterior summaries of random effects}
\usage{
getDiag(
  fitted,
  inla_mod = deprecated(),
  field = c("space", "time", "spacetime")[1],
  CI = 0.95,
  draws = NULL,
  nsim = 1000,
  ...
)
}
\arguments{
\item{fitted}{output from \code{\link{smoothDirect}} or \code{\link{smoothCluster}}}

\item{inla_mod}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} replaced by \code{fitted}.}

\item{field}{which random effects to plot. It can be one of the following: space, time, and spacetime.}

\item{CI}{Desired level of credible intervals}

\item{draws}{Posterior samples drawn from the fitted model. This argument allows the previously sampled draws (by setting save.draws to be TRUE) be used in new aggregation tasks.}

\item{nsim}{number of simulations, only applicable for the cluster-level model space-time interaction terms when random slopes are included.}

\item{...}{Unused arguments, for users with fitted object from the package before v1.0.0, arguments including Amat, year.label, and year.range can still be specified manually.}
}
\value{
List of diagnostic plots
}
\description{
Extract posterior summaries of random effects
}
\examples{
\dontrun{
  data(DemoMap)
  years <- levels(DemoData[[1]]$time)
  
  # obtain direct estimates
  data <- getDirectList(births = DemoData, 
  years = years,  
  regionVar = "region", timeVar = "time", 
  clusterVar = "~clustid+id", 
  ageVar = "age", weightsVar = "weights", 
  geo.recode = NULL)
  # obtain direct estimates
  data_multi <- getDirectList(births = DemoData, years = years,
    regionVar = "region",  timeVar = "time", clusterVar = "~clustid+id",
    ageVar = "age", weightsVar = "weights", geo.recode = NULL)
  data <- aggregateSurvey(data_multi)
  
  #  national model
  years.all <- c(years, "15-19")
  fit1 <- smoothDirect(data = data, geo = DemoMap$geo, Amat = DemoMap$Amat, 
    year.label = years.all, year.range = c(1985, 2019), 
    rw = 2, is.yearly=FALSE, m = 5)
random.time <- getDiag(fit1, field = "time")
  random.space <- getDiag(fit1, field = "space")
  random.spacetime <- getDiag(fit1, field = "spacetime")
}

}
\author{
Zehang Richard Li
}
