% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{get_data}
\alias{get_data}
\alias{get_weights}
\alias{get_weightsfun}
\alias{get_specs}
\alias{summary_weights}
\title{Extracting from a Stressed Model}
\usage{
get_data(object, xCol = "all")

get_weights(object, wCol = "all")

get_weightsfun(object, wCol = "all")

get_specs(object, wCol = "all")

summary_weights(object, wCol = "all")
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object.}

\item{xCol}{Numeric or character vector, (names of) the columns of 
the underlying data 
of the \code{object} (\code{default = "all"}).}

\item{wCol}{Vector, the columns of the scenario weights 
of the \code{object} corresponding to different 
stresses (\code{default = "all"}).}
}
\value{
\code{get_data}: A data.frame containing the realisations of 
        the stochastic model on which the \code{object} is based.

\code{get_weights:} A data.frame containing the scenario 
    weights of the \code{object}. Columns corresponds 
    to different stresses.

\code{get_weightsfun}: A list containing functions, which, 
    when applied to a column of the data, generate the 
    scenario weights of the \code{object}. The corresponding stressed 
    columns can be obtained via \code{get_specs}.\cr
    
    Use \code{\link{get_weights}} if the \code{SWIM} object only contains 
    scenario weights and not a list of functions.

\code{get_specs}: A data.frame containing specifications 
        of the stresses with each row corresponding to a different 
        stress. Only a selection of the specifications is returned; 
        however, all input variables are stored in the \code{object}.
        See also \code{\link{SWIM}}.

\code{summary_weights}: print a list containing summary statistics 
        of the stresses with each element being a table for a different stress. 
        The summary statistics include minimum, maximum, standard deviation, 
        Gini coefficient, entropy and effective sample size. 
        
        Gini coefficient uses the formula \eqn{\frac{\sum_{i=1}^{n} \sum_{j=1}^{n}\left|x_{i}-x_{j}\right|}{2 n^{2} \bar{x}}}.
        
        Effective Sample Size is equal to n / (1+Var(W)), see 
        Equation (9.13) in Owen, Art B. "Monte Carlo theory, methods and examples." (2013).
}
\description{
Extracting the data (realisations of the stochastic model), the 
    scenario weights, the functions generating the scenario weights, 
    or the specifications of the stress from an object of class 
    \code{SWIM} or \code{SWIMw}.
}
\section{Functions}{
\itemize{
\item \code{get_data}: extracting data.

\item \code{get_weights}: extracting scenario weights.

\item \code{get_weightsfun}: extracting weight functions.

\item \code{get_specs}: extracting information of the stress.

\item \code{summary_weights}: extracting summary statistics of scenario weights.
}}

\examples{
## continuing example in stress_VaR
set.seed(0)
x <- as.data.frame(cbind(
     "normal" = rnorm(1000), 
     "gamma" = rgamma(1000, shape = 2)))
  res1 <- stress(type = "VaR", x = x, 
                 alpha = 0.9, q_ratio = 1.05, k = 1)

## returning the underlying data
all(get_data(res1) == x)
 ## the scenario weights
w <- get_weights(res1) 
get_weightsfun(res1)
get_specs(res1)
  
## now add a stress on the means of both variables
res1 <- stress(type = "mean", x = res1, k = 1:2, new_means = c(0.5,1.5))
get_specs(res1)
## the required moments for a stress of type "mean" are not displayed 
## the type of stress and the specs for the second stress can be 
## extracted directly from the SWIM object.
res1$type[[2]]
res1$specs[[2]]
                                             
                                                              
                                                                                                
}
\seealso{
\code{\link{SWIM}}
}
\author{
Silvana M. Pesenti
}
