% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{mean_stressed}
\alias{mean_stressed}
\title{Mean of a Stressed Model}
\usage{
mean_stressed(object, xCol = "all", wCol = "all", base = FALSE)
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object.}

\item{xCol}{Numeric or character vector, (names of) the columns of 
the underlying data 
of the \code{object} (\code{default = "all"}).}

\item{wCol}{Vector, the columns of the scenario weights 
of the \code{object} corresponding to different 
stresses (\code{default = "all"}).}

\item{base}{Logical, if \code{TRUE}, statistics under the baseline 
are also returned (\code{default = "FALSE"}).}
}
\value{
A matrix containing the means of the \code{xCol}
    components of the stressed model with weights \code{wCol}.
}
\description{
Provides the mean of stressed model components (random variables) under the scenario weights.
}
\details{
\code{mean_stressed}: Sample mean of chosen stressed model components, subject to the calculated scenario weights.
}
\examples{
     
## example with a stress on VaR
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress(type = "VaR", x = x, 
  alpha = c(0.9, 0.95), q_ratio = 1.05)
## stressed mean
mean_stressed(res1, xCol = "all", wCol = "all", base = TRUE)

}
\seealso{
See \code{\link{var_stressed}} and \code{\link{sd_stressed}} compute
    stressed variance and standard deviations under the scenario weights, respectively.
}
\author{
Kent Wu
}
