% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_quantile.R
\name{plot_quantile}
\alias{plot_quantile}
\title{Plotting Quantile Functions of a Stressed Model}
\usage{
plot_quantile(
  object,
  xCol = 1,
  wCol = "all",
  base = FALSE,
  n = 500,
  x_limits,
  y_limits,
  displ = TRUE
)
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object.}

\item{xCol}{Numeric or character, (name of) the column of the underlying data
of the \code{object} (\code{default = 1}).}

\item{wCol}{Vector, the columns of the scenario weights 
of the \code{object} corresponding to different 
stresses (\code{default = "all"}).}

\item{base}{Logical, if \code{TRUE}, statistics under the baseline 
are also returned (\code{default = "FALSE"}).}

\item{n}{Integer, the number of points used to plot 
(\code{default = 500}).}

\item{x_limits}{Vector, the limits of the x-axis of the plot, the
value for \code{xlim} in the \code{coord_cartesian}
function in \code{ggplot}.}

\item{y_limits}{Vector, the limits of the y-axis of the plot, the
value for \code{ylim} in the \code{coord_cartesian}
function in \code{ggplot}.}

\item{displ}{Logical, if \code{TRUE} the plot is displayed,
otherwise the data.frame for customised plotting with
\code{ggplot} is returned (\code{default = TRUE}).}
}
\value{
If \code{displ = TRUE}, a plot displaying the empirical or KDE 
    quantile function of the stochastic model under the
    scenario weights.

    If \code{displ = FALSE}, a data.frame for customised plotting with
    \code{ggplot}. The data.frame contains the following columns:
    \code{grid}, the grid points to plot the quantiles,
    \code{stress} (the stresses) and \code{value} (the quantile values). \cr
    Denote by \code{res} the return of the function call, then
    \code{ggplot} can be called via:
    \deqn{ggplot(res, aes(x = res[ ,1], y = value))}
    \deqn{ + geom_lines(aes(color = factor(stress))).}
}
\description{
Plots the empirical quantile function of a stressed SWIM model
    component (random variable) or KDE quantile function of a stressed
    SWIMw model component under the scenario weights.
}
\examples{
## example with a stress on VaR
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(10 ^ 5),
  "gamma" = rgamma(10 ^ 5, shape = 2)))
res1 <- stress(type = "VaR", x = x,
  alpha = c(0.75, 0.95), q_ratio = 1.15)
plot_quantile(res1, xCol = 1, wCol = 1:2, base = TRUE)
plot_quantile(res1, xCol = 1, wCol = 1:2, base = TRUE, x_limits = c(0.8, 1), 
              y_limits = c(0, 5))

}
\seealso{
See \code{\link{quantile_stressed}} for sample quantiles of a 
    stressed model and \code{\link{plot_cdf}} for plotting empirical or KDE 
    distribution functions under scenario weights.
}
\author{
Silvana M. Pesenti, Zhuomin Mao
}
